﻿using System;
using System.Windows.Data;

namespace Microscopic_Traffic_Simulator.Converters
{
    /// <summary>
    /// Converter from bool status to empty string or string "*".
    /// </summary>
    class FromBoolToStar : IValueConverter
    {
        /// <summary>
        /// Convert bool status to string or string "*".
        /// </summary>
        /// <param name="value">Boolean status.</param>
        /// <param name="targetType">Target type which is string.</param>
        /// <param name="parameter">Parameter defined in UI. Not used.</param>
        /// <param name="culture">Current culture info.</param>
        /// <returns>Empty string if boolean status is true, "*" string if it is false.</returns>
        public object Convert(object value, Type targetType, object parameter,
            System.Globalization.CultureInfo culture)
        {
            if ((bool)value)
                return string.Empty;
            else
                return "*";
        }

        /// <summary>
        /// Convert empty string or string "*" to bool status.
        /// </summary>
        /// <param name="value">Empoty string or string "*".</param>
        /// <param name="targetType">Target type which is bool.</param>
        /// <param name="parameter">Parameter defined in UI. Not used.</param>
        /// <param name="culture">Current culture info.</param>
        /// <returns>UICulture string.</returns>
        public object ConvertBack(object value, Type targetType, object parameter,
            System.Globalization.CultureInfo culture)
        {
            if ((string)value == string.Empty)
                return true;
            else if ((string)value == "*")
                return false;
            else
                throw new ApplicationException(App.FindStringResource("UnexpectedErrorMessage"));
        }
    }
}
